import React from "react";
import { BrowserRouter, Routes as RouterRoutes, Route } from "react-router-dom";
import ScrollToTop from "components/ScrollToTop";
import ErrorBoundary from "components/ErrorBoundary";
import NotFound from "pages/NotFound";
import PropertyDetails from './pages/property-details';
import RemindersSystem from './pages/reminders-system';
import VouchersManagement from './pages/vouchers-management';
import LoginPage from './pages/login';
import Dashboard from './pages/dashboard';
import OwnersManagement from './pages/owners-management';
import UserProfileSettings from './pages/user-profile-settings';
import PasswordRecovery from './pages/password-recovery';
import TenantsManagement from './pages/tenants-management';
import PropertiesManagement from './pages/properties-management';
import ReportsAnalytics from './pages/reports-analytics';
import Register from './pages/register';
import IndividualVoucherCreation from './pages/individual-voucher-creation';
import ContractManagementSystem from './pages/contract-management-system';
import ContractTemplatesLibrary from './pages/contract-templates-library';
import ContractDraftingWorkspace from './pages/contract-drafting-workspace';
import DraftContractManager from './pages/draft-contract-manager';

const Routes = () => {
  return (
    <BrowserRouter>
      <ErrorBoundary>
      <ScrollToTop />
      <RouterRoutes>
        {/* Define your route here */}
        <Route path="/" element={<Dashboard />} />
        <Route path="/property-details" element={<PropertyDetails />} />
        <Route path="/reminders-system" element={<RemindersSystem />} />
        <Route path="/vouchers-management" element={<VouchersManagement />} />
        <Route path="/individual-voucher-creation" element={<IndividualVoucherCreation />} />
        <Route path="/contract-management-system" element={<ContractManagementSystem />} />
        <Route path="/contract-templates-library" element={<ContractTemplatesLibrary />} />
        <Route path="/contract-drafting-workspace" element={<ContractDraftingWorkspace />} />
        <Route path="/draft-contract-manager" element={<DraftContractManager />} />
        <Route path="/login" element={<LoginPage />} />
        <Route path="/dashboard" element={<Dashboard />} />
        <Route path="/owners-management" element={<OwnersManagement />} />
        <Route path="/user-profile-settings" element={<UserProfileSettings />} />
        <Route path="/password-recovery" element={<PasswordRecovery />} />
        <Route path="/tenants-management" element={<TenantsManagement />} />
        <Route path="/properties-management" element={<PropertiesManagement />} />
        <Route path="/reports-analytics" element={<ReportsAnalytics />} />
        <Route path="/register" element={<Register />} />
        <Route path="*" element={<NotFound />} />
      </RouterRoutes>
      </ErrorBoundary>
    </BrowserRouter>
  );
};

export default Routes;