import React, { useState } from 'react';
import Icon from '../AppIcon';
import UserProfileDropdown from './UserProfileDropdown';

const Header = ({ onMenuToggle, isMenuOpen = false }) => {
  const [notifications] = useState(3);

  const handleMenuToggle = () => {
    if (onMenuToggle) {
      onMenuToggle();
    }
  };

  return (
    <header className="fixed top-0 left-0 right-0 h-16 bg-white border-b border-gray-200 z-1000">
      <div className="flex items-center justify-between h-full px-6">
        {/* Left Section - Logo and Menu Toggle */}
        <div className="flex items-center space-x-4">
          {/* Mobile Menu Toggle */}
          <button
            onClick={handleMenuToggle}
            className="lg:hidden p-2 rounded-md hover:bg-gray-100 transition-colors duration-150"
            aria-label="Toggle menu"
          >
            <Icon 
              name={isMenuOpen ? "X" : "Menu"} 
              size={20} 
              className="text-gray-600" 
            />
          </button>

          {/* Logo */}
          <div className="flex items-center space-x-3">
            <div className="w-8 h-8 bg-primary rounded-lg flex items-center justify-center">
              <Icon name="Building2" size={20} className="text-white" />
            </div>
            <div className="hidden sm:block">
              <h1 className="text-xl font-semibold text-gray-900">PropManager</h1>
              <p className="text-xs text-gray-500 -mt-1">Gestión de Propiedades</p>
            </div>
          </div>
        </div>

        {/* Right Section - Actions and Profile */}
        <div className="flex items-center space-x-4">
          {/* Quick Actions */}
          <div className="hidden md:flex items-center space-x-2">
            <button className="p-2 rounded-md hover:bg-gray-100 transition-colors duration-150 relative">
              <Icon name="Bell" size={20} className="text-gray-600" />
              {notifications > 0 && (
                <span className="absolute -top-1 -right-1 w-5 h-5 bg-error text-white text-xs rounded-full flex items-center justify-center">
                  {notifications}
                </span>
              )}
            </button>
            
            <button className="p-2 rounded-md hover:bg-gray-100 transition-colors duration-150">
              <Icon name="Search" size={20} className="text-gray-600" />
            </button>
          </div>

          {/* User Profile Dropdown */}
          <UserProfileDropdown />
        </div>
      </div>
    </header>
  );
};

export default Header;