import React from 'react';
import { useLocation, useNavigate } from 'react-router-dom';
import Icon from '../AppIcon';

const NavigationBreadcrumbs = ({ customBreadcrumbs = null }) => {
  const location = useLocation();
  const navigate = useNavigate();

  const routeMap = {
    '/dashboard': { label: 'Panel Principal', icon: 'LayoutDashboard' },
    '/properties-management': { label: 'Propiedades', icon: 'Building2' },
    '/property-details': { label: 'Detalles de Propiedad', icon: 'Home' },
    '/tenants-management': { label: 'Inquilinos', icon: 'Users' },
    '/owners-management': { label: 'Propietarios', icon: 'UserCheck' },
    '/vouchers-management': { label: 'Comprobantes', icon: 'FileText' },
    '/reminders-system': { label: 'Recordatorios', icon: 'Clock' },
    '/reports-analytics': { label: 'Reportes', icon: 'BarChart3' },
    '/user-profile-settings': { label: 'Perfil y Configuración', icon: 'Settings' }
  };

  const generateBreadcrumbs = () => {
    if (customBreadcrumbs) {
      return customBreadcrumbs;
    }

    const pathSegments = location?.pathname?.split('/')?.filter(Boolean);
    const breadcrumbs = [
      { label: 'Inicio', path: '/dashboard', icon: 'Home' }
    ];

    let currentPath = '';
    pathSegments?.forEach((segment, index) => {
      currentPath += `/${segment}`;
      const route = routeMap?.[currentPath];
      
      if (route) {
        breadcrumbs?.push({
          label: route?.label,
          path: currentPath,
          icon: route?.icon,
          isLast: index === pathSegments?.length - 1
        });
      }
    });

    return breadcrumbs?.length > 1 ? breadcrumbs : [];
  };

  const breadcrumbs = generateBreadcrumbs();

  if (breadcrumbs?.length === 0) {
    return null;
  }

  const handleBreadcrumbClick = (path, isLast) => {
    if (!isLast && path) {
      navigate(path);
    }
  };

  return (
    <nav className="flex items-center space-x-2 text-sm text-gray-600 mb-6" aria-label="Breadcrumb">
      {breadcrumbs?.map((crumb, index) => (
        <div key={index} className="flex items-center space-x-2">
          {index > 0 && (
            <Icon name="ChevronRight" size={14} className="text-gray-400" />
          )}
          
          <button
            onClick={() => handleBreadcrumbClick(crumb?.path, crumb?.isLast)}
            className={`
              flex items-center space-x-1.5 px-2 py-1 rounded-md transition-colors duration-150
              ${crumb?.isLast 
                ? 'text-gray-900 font-medium cursor-default' :'text-gray-600 hover:text-gray-900 hover:bg-gray-100 cursor-pointer'
              }
            `}
            disabled={crumb?.isLast}
          >
            {crumb?.icon && (
              <Icon 
                name={crumb?.icon} 
                size={14} 
                className={crumb?.isLast ? 'text-primary' : 'text-gray-500'}
              />
            )}
            <span className="hidden sm:inline truncate max-w-32 md:max-w-none">
              {crumb?.label}
            </span>
            <span className="sm:hidden truncate max-w-20">
              {crumb?.label?.split(' ')?.[0]}
            </span>
          </button>
        </div>
      ))}
    </nav>
  );
};

export default NavigationBreadcrumbs;