import React from 'react';
import Icon from '../AppIcon';

const StatusIndicatorBadges = ({ 
  status, 
  variant = 'default', 
  size = 'default', 
  showIcon = true, 
  className = '',
  children 
}) => {
  const statusConfig = {
    // Payment Status
    paid: { 
      label: 'Pagado', 
      color: 'success', 
      icon: 'CheckCircle',
      bgClass: 'bg-success/10 text-success border-success/20'
    },
    pending: { 
      label: 'Pendiente', 
      color: 'warning', 
      icon: 'Clock',
      bgClass: 'bg-warning/10 text-warning border-warning/20'
    },
    overdue: { 
      label: 'Vencido', 
      color: 'error', 
      icon: 'AlertCircle',
      bgClass: 'bg-error/10 text-error border-error/20'
    },
    
    // Property Status
    occupied: { 
      label: 'Ocupada', 
      color: 'success', 
      icon: 'Users',
      bgClass: 'bg-success/10 text-success border-success/20'
    },
    vacant: { 
      label: 'Disponible', 
      color: 'primary', 
      icon: 'Home',
      bgClass: 'bg-primary/10 text-primary border-primary/20'
    },
    maintenance: { 
      label: 'Mantenimiento', 
      color: 'warning', 
      icon: 'Wrench',
      bgClass: 'bg-warning/10 text-warning border-warning/20'
    },
    
    // Document Status
    approved: { 
      label: 'Aprobado', 
      color: 'success', 
      icon: 'CheckCircle2',
      bgClass: 'bg-success/10 text-success border-success/20'
    },
    rejected: { 
      label: 'Rechazado', 
      color: 'error', 
      icon: 'XCircle',
      bgClass: 'bg-error/10 text-error border-error/20'
    },
    review: { 
      label: 'En Revisión', 
      color: 'secondary', 
      icon: 'Eye',
      bgClass: 'bg-secondary/10 text-secondary border-secondary/20'
    },
    
    // General Status
    active: { 
      label: 'Activo', 
      color: 'success', 
      icon: 'CheckCircle',
      bgClass: 'bg-success/10 text-success border-success/20'
    },
    inactive: { 
      label: 'Inactivo', 
      color: 'muted', 
      icon: 'Circle',
      bgClass: 'bg-gray-100 text-gray-600 border-gray-200'
    },
    urgent: { 
      label: 'Urgente', 
      color: 'error', 
      icon: 'AlertTriangle',
      bgClass: 'bg-error/10 text-error border-error/20'
    },
    
    // Priority Status
    high: { 
      label: 'Alta', 
      color: 'error', 
      icon: 'ArrowUp',
      bgClass: 'bg-error/10 text-error border-error/20'
    },
    medium: { 
      label: 'Media', 
      color: 'warning', 
      icon: 'Minus',
      bgClass: 'bg-warning/10 text-warning border-warning/20'
    },
    low: { 
      label: 'Baja', 
      color: 'success', 
      icon: 'ArrowDown',
      bgClass: 'bg-success/10 text-success border-success/20'
    }
  };

  const sizeClasses = {
    sm: 'px-2 py-0.5 text-xs',
    default: 'px-2.5 py-1 text-sm',
    lg: 'px-3 py-1.5 text-base'
  };

  const iconSizes = {
    sm: 12,
    default: 14,
    lg: 16
  };

  const config = statusConfig?.[status] || {
    label: children || status,
    color: 'muted',
    icon: 'Circle',
    bgClass: 'bg-gray-100 text-gray-600 border-gray-200'
  };

  return (
    <span className={`
      inline-flex items-center space-x-1.5 font-medium rounded-full border
      transition-all duration-150
      ${sizeClasses?.[size]}
      ${config?.bgClass}
      ${className}
    `}>
      {showIcon && config?.icon && (
        <Icon 
          name={config?.icon} 
          size={iconSizes?.[size]} 
          className="flex-shrink-0"
        />
      )}
      <span className="truncate">
        {children || config?.label}
      </span>
    </span>
  );
};

// Predefined badge components for common use cases
export const PaymentStatusBadge = ({ status, ...props }) => (
  <StatusIndicatorBadges status={status} {...props} />
);

export const PropertyStatusBadge = ({ status, ...props }) => (
  <StatusIndicatorBadges status={status} {...props} />
);

export const PriorityBadge = ({ priority, ...props }) => (
  <StatusIndicatorBadges status={priority} {...props} />
);

export const DocumentStatusBadge = ({ status, ...props }) => (
  <StatusIndicatorBadges status={status} {...props} />
);

// Notification badge for counts
export const NotificationBadge = ({ count, max = 99, className = '' }) => {
  if (!count || count <= 0) return null;
  
  const displayCount = count > max ? `${max}+` : count?.toString();
  
  return (
    <span className={`
      absolute -top-1 -right-1 min-w-[1.25rem] h-5 
      bg-error text-white text-xs font-medium
      rounded-full flex items-center justify-center
      border-2 border-white
      ${className}
    `}>
      {displayCount}
    </span>
  );
};

export default StatusIndicatorBadges;