import React from 'react';
import Icon from '../../../components/AppIcon';

const ContractTemplateSelector = ({ selectedTemplate, onTemplateSelect }) => {
  const templates = [
    {
      id: 'standard-rental',
      name: 'Contrato de Arriendo Estándar',
      description: 'Plantilla estándar para arriendo de viviendas residenciales',
      icon: 'Home',
      features: ['Reajuste IPC', 'Gastos comunes', 'Multas por atraso', 'Renovación automática'],
      recommended: true
    },
    {
      id: 'commercial-rental',
      name: 'Contrato de Arriendo Comercial',
      description: 'Plantilla especializada para locales comerciales y oficinas',
      icon: 'Building',
      features: ['Patente comercial', 'Modificaciones', 'Garantías adicionales', 'Cesión de derechos'],
      recommended: false
    },
    {
      id: 'furnished-rental',
      name: 'Contrato de Arriendo Amoblado',
      description: 'Para propiedades que incluyen mobiliario y electrodomésticos',
      icon: 'Sofa',
      features: ['Inventario incluido', 'Seguro mobiliario', 'Mantención incluida', 'Plazo flexible'],
      recommended: false
    },
    {
      id: 'short-term-rental',
      name: 'Contrato de Arriendo Temporal',
      description: 'Para arriendos de corta duración (menos de 6 meses)',
      icon: 'Calendar',
      features: ['Pago anticipado', 'Sin reajustes', 'Término definido', 'Depósito mayor'],
      recommended: false
    }
  ];

  return (
    <div className="bg-white border border-gray-200 rounded-lg p-6">
      <h3 className="text-lg font-semibold text-gray-900 mb-4">Seleccionar Plantilla de Contrato</h3>
      <p className="text-sm text-gray-600 mb-6">
        Elige la plantilla que mejor se adapte al tipo de propiedad y arriendo que deseas generar.
      </p>
      <div className="grid grid-cols-1 md:grid-cols-2 gap-4">
        {templates?.map((template) => (
          <div
            key={template?.id}
            className={`relative p-4 border-2 rounded-lg cursor-pointer transition-all ${
              selectedTemplate === template?.id
                ? 'border-primary bg-primary/5' :'border-gray-200 hover:border-gray-300 hover:bg-gray-50'
            }`}
            onClick={() => onTemplateSelect(template?.id)}
          >
            {template?.recommended && (
              <div className="absolute -top-2 -right-2 bg-green-500 text-white text-xs px-2 py-1 rounded-full">
                Recomendado
              </div>
            )}
            
            <div className="flex items-start space-x-3">
              <div className={`w-12 h-12 rounded-lg flex items-center justify-center ${
                selectedTemplate === template?.id
                  ? 'bg-primary text-white' :'bg-gray-100 text-gray-600'
              }`}>
                <Icon name={template?.icon} size={24} />
              </div>
              
              <div className="flex-1">
                <div className="flex items-center space-x-2">
                  <h4 className="font-medium text-gray-900">{template?.name}</h4>
                  {selectedTemplate === template?.id && (
                    <Icon name="CheckCircle" size={16} className="text-primary" />
                  )}
                </div>
                <p className="text-sm text-gray-600 mt-1">{template?.description}</p>
                
                <div className="mt-3">
                  <p className="text-xs text-gray-500 mb-2">Características incluidas:</p>
                  <div className="flex flex-wrap gap-1">
                    {template?.features?.map((feature, index) => (
                      <span
                        key={index}
                        className="text-xs bg-gray-100 text-gray-600 px-2 py-1 rounded-full"
                      >
                        {feature}
                      </span>
                    ))}
                  </div>
                </div>
              </div>
            </div>
          </div>
        ))}
      </div>
    </div>
  );
};

export default ContractTemplateSelector;