import React from 'react';
import Icon from '../../../components/AppIcon';

const MetricCard = ({ 
  title, 
  value, 
  change, 
  changeType, 
  icon, 
  iconColor = 'text-primary',
  onClick,
  loading = false,
  subtitle = null
}) => {
  const getChangeColor = () => {
    if (changeType === 'positive') return 'text-success';
    if (changeType === 'negative') return 'text-error';
    return 'text-gray-500';
  };

  const getChangeIcon = () => {
    if (changeType === 'positive') return 'TrendingUp';
    if (changeType === 'negative') return 'TrendingDown';
    return 'Minus';
  };

  if (loading) {
    return (
      <div className="glass-card p-6 rounded-lg hover-lift cursor-pointer">
        <div className="flex items-center justify-between mb-4">
          <div className="skeleton w-24 h-4"></div>
          <div className="skeleton w-8 h-8 rounded-full"></div>
        </div>
        <div className="skeleton w-32 h-8 mb-2"></div>
        <div className="skeleton w-20 h-4"></div>
      </div>
    );
  }

  return (
    <div 
      className="glass-card p-6 rounded-lg hover-lift cursor-pointer transition-all duration-150"
      onClick={onClick}
    >
      <div className="flex items-center justify-between mb-4">
        <h3 className="text-sm font-medium text-gray-600">{title}</h3>
        <div className={`w-10 h-10 rounded-full bg-gray-50 flex items-center justify-center ${iconColor}`}>
          <Icon name={icon} size={20} />
        </div>
      </div>
      
      <div className="space-y-1">
        <p className="text-2xl font-bold text-gray-900">{value}</p>
        {subtitle && (
          <p className="text-xs text-gray-500">{subtitle}</p>
        )}
        {change && (
          <div className={`flex items-center space-x-1 text-sm ${getChangeColor()}`}>
            <Icon name={getChangeIcon()} size={14} />
            <span>{change}</span>
            <span className="text-gray-500">vs mes anterior</span>
          </div>
        )}
      </div>
    </div>
  );
};

export default MetricCard;