import React from 'react';
import { useNavigate } from 'react-router-dom';
import Button from '../../../components/ui/Button';

const QuickActionButtons = () => {
  const navigate = useNavigate();

  const handleMassReminders = () => {
    navigate('/reminders-system');
  };

  const handleGenerateReport = () => {
    navigate('/reports-analytics');
  };

  const handleContractDrafting = () => {
    navigate('/contract-templates-library');
  };

  const handleManageVouchers = () => {
    navigate('/vouchers-management');
  };

  return (
    <div className="flex flex-col sm:flex-row gap-3">
      <Button
        variant="default"
        iconName="FileEdit"
        iconPosition="left"
        onClick={handleContractDrafting}
        className="flex-1"
      >
        Redactar Contrato
      </Button>
      
      <Button
        variant="outline"
        iconName="Send"
        iconPosition="left"
        onClick={handleMassReminders}
        className="flex-1"
      >
        Recordatorios Masivos
      </Button>
      
      <Button
        variant="secondary"
        iconName="BarChart3"
        iconPosition="left"
        onClick={handleGenerateReport}
        className="flex-1"
      >
        Generar Reporte
      </Button>
      
      <Button
        variant="ghost"
        iconName="FileText"
        iconPosition="left"
        onClick={handleManageVouchers}
        className="flex-1"
      >
        Gestionar Comprobantes
      </Button>
    </div>
  );
};

export default QuickActionButtons;