import React from 'react';
import { PieChart, Pie, Cell, ResponsiveContainer, Tooltip, Legend } from 'recharts';

const VoucherDistributionChart = ({ loading = false }) => {
  const voucherData = [
    { name: 'Pagados', value: 45, color: '#38b000' },
    { name: 'Pendientes', value: 28, color: '#ff9e00' },
    { name: 'Vencidos', value: 12, color: '#ff006e' },
    { name: 'Enviados', value: 15, color: '#3a86ff' }
  ];

  const total = voucherData?.reduce((sum, item) => sum + item?.value, 0);

  const CustomTooltip = ({ active, payload }) => {
    if (active && payload && payload?.length) {
      const data = payload?.[0];
      const percentage = ((data?.value / total) * 100)?.toFixed(1);
      return (
        <div className="bg-white p-3 rounded-lg shadow-lg border border-gray-200">
          <p className="text-sm font-medium text-gray-900">{data?.name}</p>
          <p className="text-sm" style={{ color: data?.payload?.color }}>
            {`${data?.value} comprobantes (${percentage}%)`}
          </p>
        </div>
      );
    }
    return null;
  };

  const CustomLegend = ({ payload }) => {
    return (
      <div className="flex flex-wrap justify-center gap-4 mt-4">
        {payload?.map((entry, index) => (
          <div key={index} className="flex items-center space-x-2">
            <div 
              className="w-3 h-3 rounded-full"
              style={{ backgroundColor: entry?.color }}
            ></div>
            <span className="text-sm text-gray-600">{entry?.value}</span>
            <span className="text-xs text-gray-500">
              ({voucherData?.find(item => item?.name === entry?.value)?.value})
            </span>
          </div>
        ))}
      </div>
    );
  };

  if (loading) {
    return (
      <div className="glass-card p-6 rounded-lg">
        <div className="skeleton w-48 h-6 mb-4"></div>
        <div className="skeleton w-full h-64"></div>
      </div>
    );
  }

  return (
    <div className="glass-card p-6 rounded-lg">
      <div className="flex items-center justify-between mb-6">
        <h3 className="text-lg font-semibold text-gray-900">Distribución de Comprobantes</h3>
        <div className="text-right">
          <p className="text-2xl font-bold text-gray-900">{total}</p>
          <p className="text-sm text-gray-500">Total Agosto</p>
        </div>
      </div>
      <div className="w-full h-64">
        <ResponsiveContainer width="100%" height="100%">
          <PieChart>
            <Pie
              data={voucherData}
              cx="50%"
              cy="50%"
              innerRadius={60}
              outerRadius={100}
              paddingAngle={2}
              dataKey="value"
            >
              {voucherData?.map((entry, index) => (
                <Cell key={`cell-${index}`} fill={entry?.color} />
              ))}
            </Pie>
            <Tooltip content={<CustomTooltip />} />
            <Legend content={<CustomLegend />} />
          </PieChart>
        </ResponsiveContainer>
      </div>
    </div>
  );
};

export default VoucherDistributionChart;