import React, { useState } from 'react';
import Button from '../../../components/ui/Button';
import Icon from '../../../components/AppIcon';

const BulkActionsBar = ({ selectedCount, onBulkAction }) => {
  const [showConfirmDelete, setShowConfirmDelete] = useState(false);

  const handleBulkDelete = () => {
    setShowConfirmDelete(true);
  };

  const confirmDelete = () => {
    onBulkAction?.('delete');
    setShowConfirmDelete(false);
  };

  const handleBulkExport = () => {
    onBulkAction?.('export');
  };

  const handleBulkShare = () => {
    onBulkAction?.('share');
  };

  if (selectedCount === 0) return null;

  return (
    <>
      <div className="bg-primary/10 border border-primary/20 rounded-lg p-4 mb-6">
        <div className="flex items-center justify-between">
          <div className="flex items-center space-x-3">
            <div className="w-8 h-8 bg-primary rounded-full flex items-center justify-center">
              <span className="text-sm font-bold text-white">{selectedCount}</span>
            </div>
            <span className="text-sm font-medium text-gray-900">
              {selectedCount === 1 ? '1 borrador seleccionado' : `${selectedCount} borradores seleccionados`}
            </span>
          </div>

          <div className="flex items-center space-x-2">
            <Button
              variant="outline"
              size="sm"
              onClick={handleBulkShare}
              className="flex items-center space-x-2"
            >
              <Icon name="Share2" size={14} />
              <span>Compartir</span>
            </Button>

            <Button
              variant="outline"
              size="sm"
              onClick={handleBulkExport}
              className="flex items-center space-x-2"
            >
              <Icon name="Download" size={14} />
              <span>Exportar</span>
            </Button>

            <Button
              variant="outline"
              size="sm"
              onClick={handleBulkDelete}
              className="flex items-center space-x-2 text-error border-error/20 hover:bg-error/10"
            >
              <Icon name="Trash2" size={14} />
              <span>Eliminar</span>
            </Button>
          </div>
        </div>
      </div>

      {/* Confirm Delete Modal */}
      {showConfirmDelete && (
        <div className="fixed inset-0 bg-black bg-opacity-50 z-[1001] flex items-center justify-center p-4">
          <div className="bg-white rounded-lg max-w-md w-full">
            <div className="p-6">
              <div className="flex items-center space-x-3 mb-4">
                <div className="w-10 h-10 bg-error/10 rounded-full flex items-center justify-center">
                  <Icon name="AlertTriangle" size={20} className="text-error" />
                </div>
                <h3 className="text-lg font-semibold text-gray-900">Confirmar Eliminación</h3>
              </div>
              
              <p className="text-gray-600 mb-6">
                ¿Estás seguro de que deseas eliminar {selectedCount} {selectedCount === 1 ? 'borrador' : 'borradores'}? 
                Esta acción no se puede deshacer.
              </p>

              <div className="flex items-center justify-end space-x-3">
                <Button
                  variant="outline"
                  onClick={() => setShowConfirmDelete(false)}
                >
                  Cancelar
                </Button>
                <Button
                  onClick={confirmDelete}
                  className="bg-error text-white hover:bg-error/90"
                >
                  <Icon name="Trash2" size={16} className="mr-2" />
                  Eliminar
                </Button>
              </div>
            </div>
          </div>
        </div>
      )}
    </>
  );
};

export default BulkActionsBar;