import React from 'react';
import Select from '../../../components/ui/Select';

const DraftFilters = ({ filters, onFiltersChange, loading = false }) => {
  const handleFilterChange = (key, value) => {
    const newFilters = {
      ...filters,
      [key]: value
    };
    onFiltersChange?.(newFilters);
  };

  const statusOptions = [
    { value: 'all', label: 'Todos los estados' },
    { value: 'in-progress', label: 'En Progreso' },
    { value: 'review', label: 'En Revisión' },
    { value: 'completed', label: 'Completados' }
  ];

  const templateOptions = [
    { value: 'all', label: 'Todas las plantillas' },
    { value: 'Arriendo Residencial', label: 'Arriendo Residencial' },
    { value: 'Arriendo Comercial', label: 'Arriendo Comercial' },
    { value: 'Arriendo Temporal', label: 'Arriendo Temporal' },
    { value: 'Subarriendo', label: 'Subarriendo' }
  ];

  const dateRangeOptions = [
    { value: 'all', label: 'Todas las fechas' },
    { value: 'week', label: 'Última semana' },
    { value: 'month', label: 'Último mes' },
    { value: 'quarter', label: 'Último trimestre' }
  ];

  if (loading) {
    return (
      <div className="flex items-center space-x-4">
        {[1, 2, 3]?.map(i => (
          <div key={i} className="h-10 w-32 bg-gray-200 animate-pulse rounded-md"></div>
        ))}
      </div>
    );
  }

  return (
    <div className="flex flex-col sm:flex-row sm:items-center space-y-3 sm:space-y-0 sm:space-x-4">
      <Select
        value={filters?.status || 'all'}
        onValueChange={(value) => handleFilterChange('status', value)}
        placeholder="Estado"
      >
        {statusOptions?.map(option => (
          <option key={option?.value} value={option?.value}>
            {option?.label}
          </option>
        ))}
      </Select>

      <Select
        value={filters?.template || 'all'}
        onValueChange={(value) => handleFilterChange('template', value)}
        placeholder="Plantilla"
      >
        {templateOptions?.map(option => (
          <option key={option?.value} value={option?.value}>
            {option?.label}
          </option>
        ))}
      </Select>

      <Select
        value={filters?.dateRange || 'all'}
        onValueChange={(value) => handleFilterChange('dateRange', value)}
        placeholder="Fecha"
      >
        {dateRangeOptions?.map(option => (
          <option key={option?.value} value={option?.value}>
            {option?.label}
          </option>
        ))}
      </Select>
    </div>
  );
};

export default DraftFilters;