import React from 'react';
import Icon from '../../../components/AppIcon';

const LoginHeader = () => {
  return (
    <div className="text-center mb-8">
      {/* App Icon */}
      <div className="inline-flex items-center justify-center w-20 h-20 bg-primary/10 rounded-2xl mb-6">
        <Icon name="Building2" size={32} className="text-primary" />
      </div>

      {/* Welcome Message */}
      <h1 className="text-3xl font-bold text-gray-900 mb-3">
        Bienvenido de vuelta
      </h1>
      <p className="text-gray-600 text-lg">
        Inicia sesión para acceder a tu panel de gestión
      </p>

      {/* Feature Highlights */}
      <div className="mt-6 grid grid-cols-3 gap-4 text-center">
        <div className="flex flex-col items-center space-y-2">
          <div className="w-10 h-10 bg-success/10 rounded-lg flex items-center justify-center">
            <Icon name="Shield" size={20} className="text-success" />
          </div>
          <span className="text-xs text-gray-500">Seguro</span>
        </div>
        <div className="flex flex-col items-center space-y-2">
          <div className="w-10 h-10 bg-primary/10 rounded-lg flex items-center justify-center">
            <Icon name="Zap" size={20} className="text-primary" />
          </div>
          <span className="text-xs text-gray-500">Rápido</span>
        </div>
        <div className="flex flex-col items-center space-y-2">
          <div className="w-10 h-10 bg-accent/10 rounded-lg flex items-center justify-center">
            <Icon name="Smartphone" size={20} className="text-gray-700" />
          </div>
          <span className="text-xs text-gray-500">Móvil</span>
        </div>
      </div>
    </div>
  );
};

export default LoginHeader;