import React from 'react';
import Icon from '../../../components/AppIcon';

const SecurityInfo = () => {
  const securityFeatures = [
    {
      icon: 'Shield',
      title: 'Enlace Seguro',
      description: 'El enlace de recuperación está encriptado y es único para tu cuenta'
    },
    {
      icon: 'Clock',
      title: 'Tiempo Limitado',
      description: 'Los enlaces expiran en 24 horas por tu seguridad'
    },
    {
      icon: 'Lock',
      title: 'Verificación Requerida',
      description: 'Solo tú puedes acceder al enlace desde tu correo electrónico'
    }
  ];

  return (
    <div className="hidden lg:block w-full max-w-md">
      <div className="space-y-6">
        <div className="text-center">
          <h3 className="text-xl font-semibold text-white mb-2">
            Recuperación Segura
          </h3>
          <p className="text-white/80">
            Tu seguridad es nuestra prioridad
          </p>
        </div>

        <div className="space-y-4">
          {securityFeatures?.map((feature, index) => (
            <div key={index} className="flex items-start space-x-4">
              <div className="w-10 h-10 bg-white/10 rounded-lg flex items-center justify-center flex-shrink-0">
                <Icon name={feature?.icon} size={20} className="text-white" />
              </div>
              <div>
                <h4 className="text-white font-medium mb-1">
                  {feature?.title}
                </h4>
                <p className="text-white/70 text-sm">
                  {feature?.description}
                </p>
              </div>
            </div>
          ))}
        </div>

        <div className="bg-white/10 rounded-lg p-4 mt-8">
          <div className="flex items-start space-x-3">
            <Icon name="Info" size={20} className="text-white/80 flex-shrink-0 mt-0.5" />
            <div>
              <p className="text-white/90 text-sm font-medium mb-1">
                ¿No recibes el correo?
              </p>
              <p className="text-white/70 text-sm">
                Revisa tu carpeta de spam o contacta a nuestro soporte técnico en 
                <span className="text-white font-medium"> soporte@propmanager.cl</span>
              </p>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default SecurityInfo;