import React, { useEffect } from 'react';
import { Helmet } from 'react-helmet';
import RecoveryForm from './components/RecoveryForm';
import SecurityInfo from './components/SecurityInfo';
import Icon from '../../components/AppIcon';

const PasswordRecovery = () => {
  useEffect(() => {
    // Set page title and meta description
    document.title = 'Recuperar Contraseña - PropManager';
  }, []);

  return (
    <>
      <Helmet>
        <title>Recuperar Contraseña - PropManager</title>
        <meta name="description" content="Recupera el acceso a tu cuenta de PropManager de forma segura mediante correo electrónico" />
        <meta name="keywords" content="recuperar contraseña, restablecer, PropManager, gestión propiedades" />
      </Helmet>
      <div className="min-h-screen bg-gradient-to-br from-primary via-primary to-secondary flex items-center justify-center p-4">
        <div className="w-full max-w-6xl mx-auto">
          <div className="grid lg:grid-cols-2 gap-12 items-center">
            {/* Left Side - Branding & Security Info */}
            <div className="text-center lg:text-left">
              {/* Logo */}
              <div className="flex items-center justify-center lg:justify-start space-x-3 mb-8">
                <div className="w-12 h-12 bg-white rounded-xl flex items-center justify-center">
                  <Icon name="Building2" size={28} className="text-primary" />
                </div>
                <div>
                  <h1 className="text-2xl font-bold text-white">PropManager</h1>
                  <p className="text-white/80 text-sm">Gestión de Propiedades</p>
                </div>
              </div>

              {/* Welcome Message - Mobile */}
              <div className="lg:hidden mb-8">
                <h2 className="text-3xl font-bold text-white mb-4">
                  Recupera tu Acceso
                </h2>
                <p className="text-white/90 text-lg">
                  Te ayudamos a restablecer tu contraseña de forma segura
                </p>
              </div>

              {/* Security Information - Desktop */}
              <SecurityInfo />
            </div>

            {/* Right Side - Recovery Form */}
            <div className="w-full">
              <RecoveryForm />
            </div>
          </div>
        </div>

        {/* Footer */}
        <div className="absolute bottom-4 left-0 right-0 text-center">
          <p className="text-white/60 text-sm">
            © {new Date()?.getFullYear()} PropManager. Todos los derechos reservados.
          </p>
        </div>
      </div>
    </>
  );
};

export default PasswordRecovery;