import React from 'react';
import Icon from '../../../components/AppIcon';
import Button from '../../../components/ui/Button';

const BulkActionsBar = ({ selectedCount, onClearSelection, onBulkAction }) => {
  if (selectedCount === 0) return null;

  const bulkActions = [
    {
      key: 'update-status',
      label: 'Cambiar Estado',
      icon: 'Edit',
      variant: 'outline'
    },
    {
      key: 'send-reminders',
      label: 'Enviar Recordatorios',
      icon: 'Bell',
      variant: 'outline'
    },
    {
      key: 'generate-reports',
      label: 'Generar Reportes',
      icon: 'FileText',
      variant: 'outline'
    },
    {
      key: 'export-data',
      label: 'Exportar Datos',
      icon: 'Download',
      variant: 'outline'
    }
  ];

  return (
    <div className="fixed bottom-6 left-1/2 transform -translate-x-1/2 z-1000">
      <div className="bg-white rounded-xl shadow-lg border border-gray-200 px-6 py-4 elevation-3">
        <div className="flex items-center space-x-6">
          {/* Selection Info */}
          <div className="flex items-center space-x-3">
            <div className="w-8 h-8 bg-primary/10 text-primary rounded-full flex items-center justify-center">
              <Icon name="Check" size={16} />
            </div>
            <div>
              <p className="text-sm font-medium text-gray-900">
                {selectedCount} propiedad{selectedCount !== 1 ? 'es' : ''} seleccionada{selectedCount !== 1 ? 's' : ''}
              </p>
              <button
                onClick={onClearSelection}
                className="text-xs text-gray-500 hover:text-gray-700 transition-colors"
              >
                Limpiar selección
              </button>
            </div>
          </div>

          {/* Divider */}
          <div className="w-px h-8 bg-gray-200" />

          {/* Bulk Actions */}
          <div className="flex items-center space-x-2">
            {bulkActions?.map((action) => (
              <Button
                key={action?.key}
                variant={action?.variant}
                size="sm"
                iconName={action?.icon}
                iconPosition="left"
                onClick={() => onBulkAction(action?.key)}
              >
                {action?.label}
              </Button>
            ))}
          </div>
        </div>
      </div>
    </div>
  );
};

export default BulkActionsBar;