import React from 'react';
import PropertyCard from './PropertyCard';
import Icon from '../../../components/AppIcon';
import Button from '../../../components/ui/Button';



const PropertyGrid = ({ 
  properties, 
  loading, 
  selectedProperties, 
  onPropertySelect, 
  onPropertyEdit 
}) => {
  if (loading) {
    return (
      <div className="space-y-4">
        {[...Array(8)]?.map((_, index) => (
          <div key={index} className="glass-card rounded-xl p-4 animate-pulse">
            <div className="flex items-center space-x-4">
              <div className="h-4 bg-gray-200 rounded w-1/3" />
              <div className="h-4 bg-gray-200 rounded w-1/4" />
              <div className="h-4 bg-gray-200 rounded w-1/6" />
            </div>
          </div>
        ))}
      </div>
    );
  }

  if (properties?.length === 0) {
    return (
      <div className="text-center py-12">
        <div className="w-16 h-16 bg-gray-100 rounded-full flex items-center justify-center mx-auto mb-4">
          <Icon name="Building2" size={24} className="text-gray-400" />
        </div>
        <h3 className="text-lg font-medium text-gray-900 mb-2">
          No se encontraron propiedades
        </h3>
        <p className="text-gray-500 mb-6">
          No hay propiedades que coincidan con los filtros aplicados.
        </p>
        <Button
          variant="outline"
          iconName="RefreshCw"
          iconPosition="left"
          onClick={() => window.location?.reload()}
        >
          Actualizar
        </Button>
      </div>
    );
  }

  return (
    <div className="space-y-4">
      {properties?.map((property) => (
        <PropertyCard
          key={property?.id}
          property={property}
          isSelected={selectedProperties?.includes(property?.id)}
          onSelect={onPropertySelect}
          onEdit={onPropertyEdit}
          viewMode="list"
        />
      ))}
    </div>
  );
};

export default PropertyGrid;