import React from 'react';

import Icon from '../../../components/AppIcon';
import StatusIndicatorBadges from '../../../components/ui/StatusIndicatorBadges';


const PropertyDetailsHeader = ({ propertyData }) => {
  const customBreadcrumbs = [
    { label: 'Inicio', path: '/dashboard', icon: 'Home' },
    { label: 'Propiedades', path: '/properties-management', icon: 'Building2' },
    { label: propertyData?.address, path: '/property-details', icon: 'MapPin', isLast: true }
  ];

  const handleGenerateReport = () => {
    console.log('Generating property report...');
  };

  const handleSendCommunication = () => {
    console.log('Opening communication modal...');
  };

  const handleViewVouchers = () => {
    console.log('Navigating to vouchers...');
  };

  const handleScheduleMaintenance = () => {
    console.log('Opening maintenance scheduler...');
  };

  const formatCurrency = (amount) => {
    return new Intl.NumberFormat('es-CL', {
      style: 'currency',
      currency: 'CLP',
      minimumFractionDigits: 0
    })?.format(amount);
  };

  return (
    <div className="glass-card rounded-xl p-6 mb-6 border-l-4 border-l-primary">
      {/* Main Header */}
      <div className="flex flex-col lg:flex-row lg:items-center lg:justify-between mb-6">
        {/* Property Info */}
        <div className="flex-1 mb-4 lg:mb-0">
          <div className="flex items-center space-x-3 mb-2">
            <h1 className="text-2xl font-bold text-gray-900">
              {propertyData?.address}
            </h1>
            <StatusIndicatorBadges status={propertyData?.status} size="md" />
          </div>
          
          <div className="flex items-center space-x-4 text-gray-600 mb-2">
            <div className="flex items-center space-x-2">
              <Icon name="MapPin" size={16} className="text-gray-400" />
              <span>{propertyData?.commune}, {propertyData?.city}</span>
            </div>
            
            <div className="flex items-center space-x-2">
              <Icon name="Hash" size={16} className="text-gray-400" />
              <span>{propertyData?.propertyCode}</span>
            </div>
          </div>

          <div className="flex items-center space-x-6 text-sm text-gray-600">
            <div className="flex items-center space-x-1">
              <Icon name="Bed" size={16} className="text-gray-400" />
              <span>{propertyData?.bedrooms} dormitorios</span>
            </div>
            <div className="flex items-center space-x-1">
              <Icon name="Bath" size={16} className="text-gray-400" />
              <span>{propertyData?.bathrooms} baños</span>
            </div>
            <div className="flex items-center space-x-1">
              <Icon name="Square" size={16} className="text-gray-400" />
              <span>{propertyData?.builtArea}m² construidos</span>
            </div>
            <div className="flex items-center space-x-1">
              <Icon name="Car" size={16} className="text-gray-400" />
              <span>{propertyData?.parkingSpaces} estacionamiento</span>
            </div>
          </div>
        </div>

        {/* Quick Stats */}
        <div className="flex flex-col sm:flex-row lg:flex-col gap-4">
          <div className="text-right">
            <div className="text-sm text-gray-600">Arriendo Mensual</div>
            <div className="text-2xl font-bold text-primary">
              {formatCurrency(propertyData?.monthlyRent)}
            </div>
          </div>
          
          <div className="text-right">
            <div className="text-sm text-gray-600">Ocupación</div>
            <div className="text-lg font-semibold text-green-600">
              {propertyData?.occupancyRate}%
            </div>
          </div>
        </div>
      </div>

      {/* Enhanced Summary with Utility Amounts - REQUIRED BY USER */}
      <div className="grid grid-cols-1 md:grid-cols-3 gap-6 pt-6 border-t border-gray-200">
        <div className="space-y-3">
          <h3 className="font-semibold text-gray-900 text-sm uppercase tracking-wide flex items-center space-x-2">
            <Icon name="Receipt" size={16} className="text-primary" />
            <span>Cuentas Básicas</span>
          </h3>
          <div className="space-y-2">
            <div className="flex items-center justify-between">
              <div className="flex items-center space-x-2">
                <Icon name="Droplets" size={16} className="text-blue-500" />
                <span className="text-sm text-gray-700">Agua</span>
              </div>
              <span className="text-sm font-medium text-blue-600">
                {formatCurrency(25000)}
              </span>
            </div>
            <div className="flex items-center justify-between">
              <div className="flex items-center space-x-2">
                <Icon name="Zap" size={16} className="text-yellow-500" />
                <span className="text-sm text-gray-700">Electricidad</span>
              </div>
              <span className="text-sm font-medium text-yellow-600">
                {formatCurrency(45000)}
              </span>
            </div>
            <div className="flex items-center justify-between">
              <div className="flex items-center space-x-2">
                <Icon name="Flame" size={16} className="text-orange-500" />
                <span className="text-sm text-gray-700">Gas</span>
              </div>
              <span className="text-sm font-medium text-orange-600">
                {formatCurrency(18000)}
              </span>
            </div>
          </div>
        </div>

        <div className="space-y-3">
          <h3 className="font-semibold text-gray-900 text-sm uppercase tracking-wide flex items-center space-x-2">
            <Icon name="Building" size={16} className="text-primary" />
            <span>Gastos Comunes</span>
          </h3>
          <div className="flex items-center justify-between">
            <div className="flex items-center space-x-2">
              <Icon name="Building" size={16} className="text-purple-500" />
              <span className="text-sm text-gray-700">Administración</span>
            </div>
            <span className="text-sm font-medium text-purple-600">
              {formatCurrency(45000)}
            </span>
          </div>
          <div className="pt-2 border-t border-gray-200">
            <div className="flex items-center justify-between">
              <span className="text-sm font-medium text-gray-900">Total Gastos:</span>
              <span className="text-lg font-bold text-gray-900">
                {formatCurrency(133000)}
              </span>
            </div>
          </div>
        </div>

        <div className="space-y-3">
          <h3 className="font-semibold text-gray-900 text-sm uppercase tracking-wide flex items-center space-x-2">
            <Icon name="CreditCard" size={16} className="text-primary" />
            <span>Estado de Pagos</span>
          </h3>
          <div className="space-y-2">
            <div className="flex items-center justify-between">
              <div className="flex items-center space-x-2">
                <Icon name="CheckCircle" size={16} className="text-green-500" />
                <span className="text-sm text-gray-700">Pagos realizados</span>
              </div>
              <span className="text-sm font-medium text-green-600">
                {propertyData?.totalPayments}
              </span>
            </div>
            <div className="flex items-center justify-between">
              <div className="flex items-center space-x-2">
                <Icon name="AlertTriangle" size={16} className="text-red-500" />
                <span className="text-sm text-gray-700">Pendientes</span>
              </div>
              <span className="text-sm font-medium text-red-600">
                {propertyData?.pendingIssues}
              </span>
            </div>
            
            {/* Payment Summary Section */}
            <div className="pt-2 border-t border-gray-200">
              <div className="flex items-center justify-between mb-2">
                <span className="text-sm font-medium text-gray-900">Total Mensual:</span>
                <span className="text-lg font-bold text-primary">
                  {formatCurrency((propertyData?.monthlyRent || 0) + 133000)}
                </span>
              </div>
              <div className="text-xs text-gray-500">
                Incluye arriendo + servicios básicos + gastos comunes
              </div>
            </div>
          </div>
        </div>
      </div>
    </div>
  );
};

export default PropertyDetailsHeader;