import React from 'react';
import Icon from '../../../components/AppIcon';

const PasswordStrengthMeter = ({ password }) => {
  const requirements = [
    { key: 'length', label: 'Mínimo 8 caracteres', test: (pwd) => pwd?.length >= 8 },
    { key: 'uppercase', label: 'Una letra mayúscula', test: (pwd) => /[A-Z]/?.test(pwd) },
    { key: 'lowercase', label: 'Una letra minúscula', test: (pwd) => /[a-z]/?.test(pwd) },
    { key: 'number', label: 'Un número', test: (pwd) => /\d/?.test(pwd) },
    { key: 'special', label: 'Un carácter especial', test: (pwd) => /[!@#$%^&*(),.?":{}|<>]/?.test(pwd) }
  ];

  const metRequirements = requirements?.filter(req => req?.test(password));
  const strength = metRequirements?.length;
  
  const getStrengthColor = () => {
    if (strength <= 2) return 'bg-error';
    if (strength <= 3) return 'bg-warning';
    if (strength <= 4) return 'bg-primary';
    return 'bg-success';
  };

  const getStrengthLabel = () => {
    if (strength <= 2) return 'Débil';
    if (strength <= 3) return 'Regular';
    if (strength <= 4) return 'Buena';
    return 'Excelente';
  };

  if (!password) return null;

  return (
    <div className="mt-3 space-y-3">
      {/* Strength Bar */}
      <div className="space-y-2">
        <div className="flex justify-between items-center">
          <span className="text-sm text-gray-600">Seguridad de la contraseña</span>
          <span className={`text-sm font-medium ${
            strength <= 2 ? 'text-error' : 
            strength <= 3 ? 'text-warning' : 
            strength <= 4 ? 'text-primary' : 'text-success'
          }`}>
            {getStrengthLabel()}
          </span>
        </div>
        
        <div className="w-full bg-gray-200 rounded-full h-2">
          <div 
            className={`h-2 rounded-full transition-all duration-300 ${getStrengthColor()}`}
            style={{ width: `${(strength / 5) * 100}%` }}
          />
        </div>
      </div>
      {/* Requirements List */}
      <div className="space-y-1">
        {requirements?.map((req) => {
          const isMet = req?.test(password);
          return (
            <div key={req?.key} className="flex items-center space-x-2">
              <Icon 
                name={isMet ? "CheckCircle2" : "Circle"} 
                size={14} 
                className={isMet ? 'text-success' : 'text-gray-400'}
              />
              <span className={`text-xs ${isMet ? 'text-success' : 'text-gray-500'}`}>
                {req?.label}
              </span>
            </div>
          );
        })}
      </div>
    </div>
  );
};

export default PasswordStrengthMeter;