import React, { useState } from 'react';
import Input from '../../../components/ui/Input';

const PhoneNumberInput = ({ value, onChange, error, required = false }) => {
  const [formattedValue, setFormattedValue] = useState(value || '');

  const formatChileanPhone = (input) => {
    // Remove all non-digits
    const digits = input?.replace(/\D/g, '');
    
    // Limit to 9 digits (Chilean mobile numbers)
    const limitedDigits = digits?.slice(0, 9);
    
    // Format as +56 9 XXXX XXXX
    if (limitedDigits?.length === 0) return '';
    if (limitedDigits?.length <= 1) return `+56 ${limitedDigits}`;
    if (limitedDigits?.length <= 5) return `+56 ${limitedDigits?.slice(0, 1)} ${limitedDigits?.slice(1)}`;
    return `+56 ${limitedDigits?.slice(0, 1)} ${limitedDigits?.slice(1, 5)} ${limitedDigits?.slice(5)}`;
  };

  const handleChange = (e) => {
    const input = e?.target?.value;
    const formatted = formatChileanPhone(input);
    setFormattedValue(formatted);
    
    // Extract only digits for the actual value
    const digits = input?.replace(/\D/g, '');
    onChange(digits);
  };

  return (
    <Input
      type="tel"
      label="Número de Teléfono"
      placeholder="+56 9 XXXX XXXX"
      value={formattedValue}
      onChange={handleChange}
      error={error}
      required={required}
      description="Formato: +56 9 XXXX XXXX (móvil chileno)"
    />
  );
};

export default PhoneNumberInput;