import React from 'react';
import { Checkbox } from '../../../components/ui/Checkbox';

const TermsCheckbox = ({ checked, onChange, error }) => {
  const handleTermsClick = (e) => {
    e?.preventDefault();
    // In a real app, this would open terms modal or navigate to terms page
    window.open('/terms-of-service', '_blank');
  };

  const handlePrivacyClick = (e) => {
    e?.preventDefault();
    // In a real app, this would open privacy policy modal or navigate to privacy page
    window.open('/privacy-policy', '_blank');
  };

  return (
    <div className="space-y-2">
      <Checkbox
        checked={checked}
        onChange={(e) => onChange(e?.target?.checked)}
        error={error}
        label={
          <span className="text-sm text-gray-700">
            Acepto los{' '}
            <button
              type="button"
              onClick={handleTermsClick}
              className="text-primary hover:text-primary/80 underline font-medium"
            >
              Términos de Servicio
            </button>
            {' '}y la{' '}
            <button
              type="button"
              onClick={handlePrivacyClick}
              className="text-primary hover:text-primary/80 underline font-medium"
            >
              Política de Privacidad
            </button>
          </span>
        }
        required
      />
      <p className="text-xs text-gray-500 ml-6">
        Al registrarte, confirmas que has leído y aceptas nuestros términos y condiciones, 
        así como el tratamiento de tus datos personales conforme a la legislación chilena.
      </p>
    </div>
  );
};

export default TermsCheckbox;