import React from 'react';
import { Helmet } from 'react-helmet';
import Icon from '../../components/AppIcon';
import RegistrationForm from './components/RegistrationForm';

const Register = () => {
  return (
    <>
      <Helmet>
        <title>Registro - PropManager</title>
        <meta name="description" content="Crea tu cuenta en PropManager para gestionar tus propiedades de manera eficiente" />
      </Helmet>
      <div className="min-h-screen bg-gradient-to-br from-primary via-primary/90 to-secondary flex items-center justify-center p-4">
        <div className="w-full max-w-md">
          {/* Header */}
          <div className="text-center mb-8">
            {/* Logo */}
            <div className="flex justify-center mb-6">
              <div className="w-16 h-16 bg-white rounded-2xl flex items-center justify-center shadow-lg">
                <Icon name="Building2" size={32} className="text-primary" />
              </div>
            </div>

            {/* Title */}
            <h1 className="text-3xl font-bold text-white mb-2">
              Crear Cuenta
            </h1>
            <p className="text-white/80 text-lg">
              Únete a PropManager y gestiona tus propiedades
            </p>
          </div>

          {/* Registration Card */}
          <div className="glass-card p-8 rounded-2xl shadow-2xl">
            <RegistrationForm />
          </div>

          {/* Footer */}
          <div className="text-center mt-8">
            <p className="text-white/60 text-sm">
              Al registrarte, aceptas nuestros términos de servicio y política de privacidad
            </p>
            <p className="text-white/40 text-xs mt-2">
              PropManager © {new Date()?.getFullYear()} - Gestión de Propiedades
            </p>
          </div>
        </div>
      </div>
    </>
  );
};

export default Register;