import React from 'react';
import Icon from '../../../components/AppIcon';

const KPIMetricsGrid = ({ metrics }) => {
  const formatCurrency = (amount) => {
    return new Intl.NumberFormat('es-CL', {
      style: 'currency',
      currency: 'CLP',
      minimumFractionDigits: 0
    })?.format(amount);
  };

  const formatPercentage = (value) => {
    const sign = value >= 0 ? '+' : '';
    return `${sign}${value?.toFixed(1)}%`;
  };

  const getPercentageColor = (value) => {
    if (value > 0) return 'text-success';
    if (value < 0) return 'text-error';
    return 'text-gray-500';
  };

  const getPercentageIcon = (value) => {
    if (value > 0) return 'TrendingUp';
    if (value < 0) return 'TrendingDown';
    return 'Minus';
  };

  return (
    <div className="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-8">
      {metrics?.map((metric) => (
        <div key={metric?.key} className="glass-card p-6 rounded-lg hover-lift">
          <div className="flex items-center justify-between mb-4">
            <div className={`w-12 h-12 rounded-lg flex items-center justify-center ${metric?.bgColor}`}>
              <Icon name={metric?.icon} size={24} className={metric?.iconColor} />
            </div>
            <div className="text-right">
              <div className={`flex items-center space-x-1 ${getPercentageColor(metric?.change)}`}>
                <Icon name={getPercentageIcon(metric?.change)} size={14} />
                <span className="text-sm font-medium">
                  {formatPercentage(metric?.change)}
                </span>
              </div>
            </div>
          </div>
          
          <div className="space-y-1">
            <h3 className="text-2xl font-bold text-gray-900">
              {metric?.type === 'currency' ? formatCurrency(metric?.value) : metric?.value}
            </h3>
            <p className="text-sm text-gray-600">{metric?.label}</p>
            <p className="text-xs text-gray-500">{metric?.period}</p>
          </div>
        </div>
      ))}
    </div>
  );
};

export default KPIMetricsGrid;