import React, { useState } from 'react';
import Icon from '../../../components/AppIcon';

const ReportCategoryFilter = ({ selectedCategory, onCategoryChange, categories }) => {
  const [isExpanded, setIsExpanded] = useState(true);

  return (
    <div className="bg-white border-r border-gray-200 w-64 h-full overflow-y-auto">
      <div className="p-4 border-b border-gray-100">
        <div className="flex items-center justify-between">
          <h3 className="text-lg font-semibold text-gray-900">Categorías de Reportes</h3>
          <button
            onClick={() => setIsExpanded(!isExpanded)}
            className="p-1 rounded-md hover:bg-gray-100 transition-colors duration-150"
          >
            <Icon 
              name={isExpanded ? "ChevronUp" : "ChevronDown"} 
              size={16} 
              className="text-gray-500" 
            />
          </button>
        </div>
      </div>
      {isExpanded && (
        <div className="p-2">
          {categories?.map((category) => (
            <button
              key={category?.key}
              onClick={() => onCategoryChange(category?.key)}
              className={`
                w-full flex items-center space-x-3 px-3 py-2.5 rounded-lg text-sm font-medium
                transition-all duration-150 hover-lift mb-1
                ${selectedCategory === category?.key
                  ? 'bg-primary text-white shadow-sm'
                  : 'text-gray-700 hover:bg-gray-100 hover:text-gray-900'
                }
              `}
            >
              <Icon 
                name={category?.icon} 
                size={18} 
                className={selectedCategory === category?.key ? 'text-white' : 'text-gray-500'}
              />
              <div className="flex-1 text-left">
                <div>{category?.label}</div>
                <div className={`text-xs ${selectedCategory === category?.key ? 'text-white/80' : 'text-gray-500'}`}>
                  {category?.count} reportes
                </div>
              </div>
              {category?.badge && (
                <span className={`
                  px-2 py-0.5 text-xs font-medium rounded-full
                  ${selectedCategory === category?.key
                    ? 'bg-white/20 text-white' :'bg-primary text-white'
                  }
                `}>
                  {category?.badge}
                </span>
              )}
            </button>
          ))}
        </div>
      )}
    </div>
  );
};

export default ReportCategoryFilter;