// Chilean Utility Companies Database
        export const CHILEAN_UTILITY_COMPANIES = {
          electricity: [
            {
              id: 'enel-distribucion',
              name: 'Enel Distribución Chile',
              apiSupported: true,
              contactPhone: '+56 2 2696 9696',
              website: 'https://www.enel.cl',
              coverage: ['Santiago', 'Valparaíso', 'O\'Higgins', 'Maule'],
              apiEndpoint: process.env?.VITE_ENEL_API_URL,
              apiKey: process.env?.VITE_ENEL_API_KEY
            },
            {
              id: 'cge-distribucion',
              name: 'CGE Distribución',
              apiSupported: true,
              contactPhone: '+56 2 2680 3000',
              website: 'https://www.cge.cl',
              coverage: ['O\'Higgins', 'Maule', 'Biobío'],
              apiEndpoint: process.env?.VITE_CGE_API_URL,
              apiKey: process.env?.VITE_CGE_API_KEY
            },
            {
              id: 'chilectra',
              name: 'Chilectra (Enel)',
              apiSupported: true,
              contactPhone: '+56 2 2696 9696',
              website: 'https://www.enel.cl',
              coverage: ['Santiago'],
              apiEndpoint: process.env?.VITE_CHILECTRA_API_URL,
              apiKey: process.env?.VITE_CHILECTRA_API_KEY
            },
            {
              id: 'saesa',
              name: 'SAESA',
              apiSupported: false,
              contactPhone: '+56 45 325 8000',
              website: 'https://www.saesa.cl',
              coverage: ['Araucanía', 'Los Ríos', 'Los Lagos']
            },
            {
              id: 'frontel',
              name: 'FRONTEL',
              apiSupported: false,
              contactPhone: '+56 45 405 7000',
              website: 'https://www.frontel.cl',
              coverage: ['Araucanía']
            }
          ],
          water: [
            {
              id: 'aguas-andinas',
              name: 'Aguas Andinas',
              apiSupported: true,
              contactPhone: '+56 2 2426 9000',
              website: 'https://www.aguasandinas.cl',
              coverage: ['Santiago', 'Cordillera', 'Chacabuco', 'Maipo'],
              apiEndpoint: process.env?.VITE_AGUAS_ANDINAS_API_URL,
              apiKey: process.env?.VITE_AGUAS_ANDINAS_API_KEY
            },
            {
              id: 'esval',
              name: 'ESVAL',
              apiSupported: true,
              contactPhone: '+56 32 220 3000',
              website: 'https://www.esval.cl',
              coverage: ['Valparaíso', 'Aconcagua'],
              apiEndpoint: process.env?.VITE_ESVAL_API_URL,
              apiKey: process.env?.VITE_ESVAL_API_KEY
            },
            {
              id: 'essbio',
              name: 'ESSBIO',
              apiSupported: true,
              contactPhone: '+56 41 345 3000',
              website: 'https://www.essbio.cl',
              coverage: ['Biobío', 'Ñuble', 'Araucanía'],
              apiEndpoint: process.env?.VITE_ESSBIO_API_URL,
              apiKey: process.env?.VITE_ESSBIO_API_KEY
            },
            {
              id: 'aguas-del-valle',
              name: 'Aguas del Valle',
              apiSupported: false,
              contactPhone: '+56 51 520 9000',
              website: 'https://www.aguasdelvalle.cl',
              coverage: ['Coquimbo', 'Atacama']
            }
          ],
          gas: [
            {
              id: 'metrogas',
              name: 'Metrogas',
              apiSupported: true,
              contactPhone: '+56 2 2337 8000',
              website: 'https://www.metrogas.cl',
              coverage: ['Santiago', 'Valparaíso', 'O\'Higgins', 'Maule'],
              apiEndpoint: process.env?.VITE_METROGAS_API_URL,
              apiKey: process.env?.VITE_METROGAS_API_KEY
            },
            {
              id: 'lipigas',
              name: 'Lipigas',
              apiSupported: true,
              contactPhone: '+56 2 2421 3000',
              website: 'https://www.lipigas.cl',
              coverage: ['Nacional'],
              apiEndpoint: process.env?.VITE_LIPIGAS_API_URL,
              apiKey: process.env?.VITE_LIPIGAS_API_KEY
            },
            {
              id: 'gasco',
              name: 'Gasco',
              apiSupported: true,
              contactPhone: '+56 2 2694 8000',
              website: 'https://www.gasco.cl',
              coverage: ['Nacional'],
              apiEndpoint: process.env?.VITE_GASCO_API_URL,
              apiKey: process.env?.VITE_GASCO_API_KEY
            },
            {
              id: 'abastible',
              name: 'Abastible',
              apiSupported: false,
              contactPhone: '+56 2 2694 2000',
              website: 'https://www.abastible.cl',
              coverage: ['Nacional']
            }
          ]
        };

        // API Connection utilities
        export const connectToUtilityAPI = async (companyId, accountNumber, serviceType) => {
          try {
            const company = CHILEAN_UTILITY_COMPANIES?.[serviceType]?.find(c => c?.id === companyId);
            
            if (!company?.apiSupported) {
              throw new Error('API no soportada para esta compañía');
            }

            // Simulate API connection
            const response = await fetch(`${company?.apiEndpoint}/connect`, {
              method: 'POST',
              headers: {
                'Authorization': `Bearer ${company?.apiKey}`,
                'Content-Type': 'application/json'
              },
              body: JSON.stringify({
                accountNumber,
                serviceType,
                action: 'connect'
              })
            });

            if (!response?.ok) {
              throw new Error(`Error de conexión: ${response.status}`);
            }

            return await response?.json();
          } catch (error) {
            console.error('Error connecting to utility API:', error);
            throw error;
          }
        };

        export const fetchUtilityBill = async (companyId, accountNumber, serviceType, month, year) => {
          try {
            const company = CHILEAN_UTILITY_COMPANIES?.[serviceType]?.find(c => c?.id === companyId);
            
            if (!company?.apiSupported) {
              throw new Error('API no soportada para esta compañía');
            }

            const response = await fetch(`${company?.apiEndpoint}/bill`, {
              method: 'GET',
              headers: {
                'Authorization': `Bearer ${company?.apiKey}`,
                'Content-Type': 'application/json'
              },
              params: {
                accountNumber,
                month,
                year
              }
            });

            if (!response?.ok) {
              throw new Error(`Error obteniendo factura: ${response.status}`);
            }

            return await response?.json();
          } catch (error) {
            console.error('Error fetching utility bill:', error);
            // Return mock data for development
            return {
              accountNumber,
              month,
              year,
              amount: Math.floor(Math.random() * 50000) + 20000,
              dueDate: new Date(year, month, 15)?.toISOString()?.split('T')?.[0],
              consumption: Math.floor(Math.random() * 100) + 50,
              company: company?.name || 'N/A'
            };
          }
        };

        // Utility to get companies by region
        export const getCompaniesByRegion = (serviceType, region) => {
          return CHILEAN_UTILITY_COMPANIES?.[serviceType]?.filter(company => 
            company?.coverage?.includes(region)
          ) || [];
        };

        // Mock data generator for development
        export const generateMockUtilityData = (serviceType, companyId) => {
          const company = CHILEAN_UTILITY_COMPANIES?.[serviceType]?.find(c => c?.id === companyId);
          
          return {
            companyName: company?.name || 'Compañía Desconocida',
            accountNumber: `ACC-${Math.floor(Math.random() * 1000000)}`,
            currentBill: Math.floor(Math.random() * 50000) + 15000,
            lastPayment: new Date(Date.now() - Math.random() * 30 * 24 * 60 * 60 * 1000)?.toISOString()?.split('T')?.[0],
            nextDueDate: new Date(Date.now() + Math.random() * 30 * 24 * 60 * 60 * 1000)?.toISOString()?.split('T')?.[0],
            status: Math.random() > 0.2 ? 'paid' : 'pending',
            apiConnected: company?.apiSupported && Math.random() > 0.3
          };
        };